![[Pasted image 20250427100733.png]]

## Overview of Web Proxy
- **Purpose**: Acts as a middleman between users and servers for HTTP, HTTPS, and FTP traffic.
- **Two TCP Sockets per Request**:
    - Between the user and the Secure Web Appliance.
    - Between the Secure Web Appliance and the origin server.
- **Modes of Deployment**:
    - **Transparent Mode**: Proxy is hidden from users; Secure Web Appliance pretends to be the Origin Content Server (OCS).
    - **Explicit Mode**: Users are aware of the proxy and connect to it directly.

## Deployment Modes
### **Transparent Proxy Mode**
- **Key Features**:
    - Users are unaware of the proxy.
    - Web traffic is redirected to the Secure Web Appliance by network devices like switches, routers, or firewalls.
- **Traffic Redirection Methods**:
    - **Policy-Based Routing (PBR)**: Redirects traffic based on IP, port, or other attributes.
    - **Web Cache Control Protocol (WCCP)**: Cisco-developed protocol for redirecting traffic to the Secure Web Appliance.
    - **Layer 4-7 Switch**: Redirection based on IP addresses, port numbers, cookies, or SSL session IDs.
- **Authentication Challenges**:
    - Transparent mode is less straightforward compared to explicit mode.

### **Explicit Proxy Mode**
- **Key Features**:
    - Users intentionally configure their browsers to use the proxy.
    - No additional network devices are needed to redirect traffic.
    - Authentication issues are easier to troubleshoot.
- **Steps in Explicit Mode**:
    1. User sends web request directly to the Secure Web Appliance.
    2. Proxy resolves the hostname of the target server and connects on behalf of the user.
    3. Firewall allows outbound traffic only from the Secure Web Appliance.
- **Configuration**:
    - Proxy settings can be configured manually, via DHCP/DNS, or using PAC (Proxy Auto-Configuration) files.
    - PAC files allow load balancing and failover.

## Layer 4 Traffic Monitor (L4TM)
- **Purpose**: Scans all TCP/UDP sessions to detect and block suspicious traffic, such as phone-home malware activity. This is a passive approach. 
- **How It Works**:
    - Receives a copy of the original traffic redirected by a network device.
    - Limited protection by sending TCP resets or ICMP "host unreachable" messages.
- **Benefits**:
    - Identifies malware-compromised users.
    - Disrupts malware phone-home activity.
- **Default Behavior**: Monitors and logs suspicious activity unless configured to actively disrupt sessions.

## FTP and SOCKS Proxy
- **FTP Proxy**:
    - Intercepts both active and passive FTP connections.
    - Methods supported:
        - **FTP over HTTP**: Translates HTTP-to-FTP communication.
        - **FTP over HTTP Tunneling**: Requires open ports for PASV commands.
        - **Native FTP**: Direct FTP connections with or without user awareness.
- **SOCKS Proxy**:
    - Operates at Layer 5 (Session Layer) of the OSI model.
    - Facilitates secure communication by negotiating connections between client and server.

## High Availability for Secure Web Appliance
### **Explicit Deployment**
- **Methods**:
    - **Load Balancer**: Distributes traffic across multiple appliances.
    - **PAC Files**: Direct clients to multiple proxies based on conditions.
    - **CARP Protocol**:
        - Provides failover using virtual IP addresses.
        - Backup hosts take over if the primary host fails.
![[Pasted image 20250427100450.png]]

### **Transparent Deployment**
- **WCCP**:
    - Built-in redundancy and failover.
    - Load-sharing across multiple appliances via service groups.
![[Pasted image 20250427100553.png]]

## Web Cache Control Protocol (WCCP)
- **Purpose**: Redirects traffic transparently in real-time.
- **Benefits**:
    - No user-side configuration required.
    - Built-in load balancing, scaling, and fault tolerance.
    - Reduces transmission costs and improves download performance.
- **How It Works**:
    1. User initiates a web request.
    2. WCCP-enabled device redirects the request to the Secure Web Appliance.
    3. Secure Web Appliance inspects and processes the request.
    4. Traffic is forwarded to the web server if compliant with policies.

### Key Features of the Secure Web Appliance
- Acts as a forward proxy in explicit and transparent modes.
- Intercepts and inspects HTTP, HTTPS, and FTP traffic.
- Provides malware detection, data loss prevention, and web traffic filtering.
- Supports high availability through load balancing, failover, and CARP virtual IP addresses.
- Integrates seamlessly with Cisco network devices like switches, routers, and firewalls.